	% Digital Filters Example 13.1 Box 13.1
	clear all
	close all
	clc
	wcT = 0.045*pi; wsT = 0.05*pi; dc = 0.01; ds = 0.001;
	for M = 2:19;
		Ng(M) =  HERRMANN_LP_FIR_ORDER([M*wcT M*wsT], [.005 .001]);
		Nf(M) =  HERRMANN_LP_FIR_ORDER([wcT 2*pi/M-wsT], [.005 .001]);
	end
	M = 1:19;
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	
	subplot('position', [0.12 0.4 0.80 0.5]);
	plot(M,Ng,'--','linewidth',2), hold on
	plot(M,Nf,':','linewidth',2)
	plot(M,Ng+Nf,'-','linewidth',2)
	set(gca,'FontName','times'),grid on
	text(11, 200,'\itH','FontName','times','FontSize',16);
	text(7, 65,'\itF','FontName','times','FontSize',16);
	text(16.5, 100,'\itG','FontName','times','FontSize',16);
	xlabel('\itM','FontName','times','FontSize',16);
	ylabel('Number of multiplications','FontName','times','FontSize',16);
	axis([2 19  0 600]);
	
